import discord

from discord.ext import commands

import json

# Charger la config

with open("config.json") as f:

    config = json.load(f)

POST_CHANNEL_ID = config["POST_CHANNEL_ID"]  # Salon où le bouton de candidature est affiché

POST_RESULT_CHANNEL_ID = config["POST_RESULT_CHANNEL_ID"]  # Salon où les candidatures sont envoyées

POST_STAFF_ROLE_ID = config["POST_STAFF_ROLE_ID"]  # Rôle du staff qui peut traiter les candidatures

FOOTER_TEXT = config["FOOTER_TEXT"]

FOOTER_ICON = config["FOOTER_ICON"]

# Vue avec boutons pour le staff

class TraitementCandidatureView(discord.ui.View):

    def __init__(self, user_id):

        super().__init__(timeout=None)

        self.user_id = user_id

    @discord.ui.button(label="✅ Retenu", style=discord.ButtonStyle.green)

    async def retenu(self, interaction: discord.Interaction, button: discord.ui.Button):

        if POST_STAFF_ROLE_ID not in [role.id for role in interaction.user.roles]:

            await interaction.response.send_message("❌ Vous n'avez pas la permission.", ephemeral=True)

            return

        

        membre = interaction.guild.get_member(self.user_id)

        if membre:

            try:

                await membre.send(

                    f"Bonjour,\n\nVotre candidature est **retenue** ✅.\n"

                    f"Merci de faire une demande de rendez-vous avec **{interaction.user.display_name}** "

                    f"pour passer à un entretien oral.\n\n"

                    "Merci,\nL'administration de Charles De Gaulle."

                )

                await interaction.response.send_message("✅ Candidature marquée comme retenue et MP envoyé.", ephemeral=True)

            except:

                await interaction.response.send_message("⚠ Impossible d'envoyer le MP au candidat.", ephemeral=True)

        else:

            await interaction.response.send_message("❌ Candidat introuvable sur le serveur.", ephemeral=True)

        button.disabled = True

        self.children[1].disabled = True

        await interaction.message.edit(view=self)

    @discord.ui.button(label="❌ Rejet", style=discord.ButtonStyle.red)

    async def rejet(self, interaction: discord.Interaction, button: discord.ui.Button):

        if POST_STAFF_ROLE_ID not in [role.id for role in interaction.user.roles]:

            await interaction.response.send_message("❌ Vous n'avez pas la permission.", ephemeral=True)

            return

        async def ask_reason():

            await interaction.response.send_message("✏ Veuillez entrer la raison du refus :", ephemeral=True)

            try:

                msg = await interaction.client.wait_for(

                    "message",

                    timeout=120,

                    check=lambda m: m.author == interaction.user and m.channel == interaction.channel

                )

                return msg.content

            except:

                return None

        raison = await ask_reason()

        if not raison:

            await interaction.followup.send("⏳ Temps écoulé ou aucune raison donnée.", ephemeral=True)

            return

        membre = interaction.guild.get_member(self.user_id)

        if membre:

            try:

                await membre.send(

                    f"Bonjour,\n\nNous avons le malheur de vous annoncer que votre candidature n'a pas été retenue ❌.\n"

                    f"**Raison** : {raison}\n\n"

                    "Cordialement,\nL'administration de Charles De Gaulle."

                )

                await interaction.followup.send("❌ Candidature rejetée et MP envoyé.", ephemeral=True)

            except:

                await interaction.followup.send("⚠ Impossible d'envoyer le MP au candidat.", ephemeral=True)

        else:

            await interaction.followup.send("❌ Candidat introuvable sur le serveur.", ephemeral=True)

        button.disabled = True

        self.children[0].disabled = True

        await interaction.message.edit(view=self)

# Modal (formulaire)

class CandidatureModal(discord.ui.Modal, title="📋 Formulaire de candidature"):

    nom_prenom = discord.ui.TextInput(label="Nom Prénom", style=discord.TextStyle.short, required=True)

    poste = discord.ui.TextInput(label="Poste (si prof, précisez la matière)", style=discord.TextStyle.short, required=True)

    motivation = discord.ui.TextInput(label="Motivation", style=discord.TextStyle.long, required=True)

    pourquoi_vous = discord.ui.TextInput(label="Pourquoi vous et pas un autre ?", style=discord.TextStyle.long, required=True)

    async def on_submit(self, interaction: discord.Interaction):

        salon_result = interaction.client.get_channel(POST_RESULT_CHANNEL_ID)

        if salon_result is None:

            await interaction.response.send_message("❌ Salon des résultats introuvable.", ephemeral=True)

            return

        embed = discord.Embed(title="📩 Nouvelle candidature", color=0x2f3136)

        embed.add_field(name="Nom Prénom", value=self.nom_prenom.value, inline=False)

        embed.add_field(name="Poste", value=self.poste.value, inline=False)

        embed.add_field(name="Motivation", value=self.motivation.value, inline=False)

        embed.add_field(name="Pourquoi vous ?", value=self.pourquoi_vous.value, inline=False)

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await salon_result.send(embed=embed, view=TraitementCandidatureView(interaction.user.id))

        await interaction.response.send_message("✅ Votre candidature a été envoyée.", ephemeral=True)

# Vue avec bouton pour lancer le formulaire

class CandidatureView(discord.ui.View):

    def __init__(self):

        super().__init__(timeout=None)

    @discord.ui.button(label="📋 Postuler", style=discord.ButtonStyle.blurple)

    async def postuler(self, interaction: discord.Interaction, button: discord.ui.Button):

        await interaction.response.send_modal(CandidatureModal())

# Cog principal

class Candidature(commands.Cog):

    def __init__(self, bot):

        self.bot = bot

    @commands.command(name="candidature-setup")

    async def candidature_setup(self, ctx):

        """Envoie l'embed candidature dans POST_CHANNEL_ID"""

        if not ctx.author.guild_permissions.administrator:

            await ctx.send("❌ Vous devez être administrateur pour utiliser cette commande.")

            return

        salon_post = self.bot.get_channel(POST_CHANNEL_ID)

        if salon_post is None:

            await ctx.send(f"❌ Erreur : salon introuvable avec l'ID `{POST_CHANNEL_ID}`")

            return

        embed = discord.Embed(

            title="📌 Recrutement ouvert",

            description="Cliquez sur le bouton ci-dessous pour déposer votre candidature.",

            color=0x2f3136

        )

        embed.set_footer(text=FOOTER_TEXT, icon_url=FOOTER_ICON)

        await salon_post.send(embed=embed, view=CandidatureView())

        await ctx.send("✅ Embed candidature envoyé.")

async def setup(bot):

    await bot.add_cog(Candidature(bot))